### 环境说明

Unity 2019.4.12f1

### 项目说明

项目地址：[下载地址](https://cloudcode-sdk.oss-cn-zhangjiakou.aliyuncs.com/demo.zip)

本项目是一个unity demo项目。 Assets/Plugins 目录下为插件代码

### 集成

##### 1. 安装 Mobile Notifications package

为了避免引入修改导出后的工程，此处我们依赖Mobile Notifications package解决一些通知配置。

参考：https://docs.unity3d.com/Packages/com.unity.mobile.notifications@1.3/manual/index.html

##### 2. 复制 Assets/Plugins 到 unity项目

目前插件直接以文件的方式提供，后续再考虑封装为Unity Package

##### 3. 启用推送通知

在 *Edit---Project Settings---Mobile Notifications*，勾选Enable Push Notifications

##### 4. 其他通用配置

1. 应用包名或者bundleId配置，需要和推送平台创建的应用一致
2. Android启用了*Custom Main Manifest* *Custom Main Gradle Template* *Custom Base Gradle Template* *Custom Proguard File*，如果项目有其他地方也需要定制这些文件，请注意合并修改内容

### Android配置

##### 配置推送参数

1. 在Assets/Plugins/Android/AndroidManifest.xml文件中

配置推送的appKey和appSecret

```
        <!-- 请填写阿里云的- appKey appSecret -->
        <meta-data
            android:name="com.alibaba.app.appkey"
            android:value="*******" />
        <meta-data
            android:name="com.alibaba.app.appsecret"
            android:value="*******" />
```

配置华为厂商通道的appId（可选）

```
        <!-- 华为通道的参数appid -->
        <meta-data
            android:name="com.huawei.hms.client.appid"
            android:value="appid=*******" />
```

配置小米厂商通道的参数（可选）

```
        <!-- 小米通道的参数 -->
        <meta-data
            android:name="com.aliyun.ams.push.xiaomi.id"
            android:value="id=*******" />
        <meta-data
            android:name="com.aliyun.ams.push.xiaomi.key"
            android:value="id=*******" />
```

配置oppo厂商通道的参数（可选）

```
        <!-- oppo通道的参数 -->
        <meta-data
            android:name="com.aliyun.ams.push.oppo.key"
            android:value="id=*******" />
        <meta-data
            android:name="com.aliyun.ams.push.oppo.secret"
            android:value="id=*******" />
```

配置vivo厂商通道的参数（可选）

```
        <!-- vivo通道的参数api_key为appkey -->
        <meta-data
            android:name="com.vivo.push.api_key"
            android:value="*******" />
        <meta-data
            android:name="com.vivo.push.app_id"
            android:value="*******" />
```

配置魅族厂商通道的参数（可选）

```
        <!-- 魅族通道的参数 -->
        <meta-data
            android:name="com.aliyun.ams.push.meizu.id"
            android:value="id=*******" />
        <meta-data
            android:name="com.aliyun.ams.push.meizu.secret"
            android:value="id=*******" />
```

2. 初始化时配置Notification Channel，参考[Manage notification channels](https://docs.unity3d.com/Packages/com.unity.mobile.notifications@1.3/manual/Android.html#manage-notification-channels)

### iOS配置

iOS参数通过api设置，不需要修改插件文件

#### 初始化参数

通过api初始化 appKey 和 appSecret
```
PushHelper.Init("********", "********", (result, data) => Log("Init " + result + " " + data));
```

#### 应用在前台时的通知展示

对于iOS来说，应用在前台时，默认是不会展示通知的，可以在接到推送的回调中，展示通知，参考[iOS notifications
](https://docs.unity3d.com/Packages/com.unity.mobile.notifications@1.3/manual/iOS.html#notification-received-callbacks)
```
            // 当iOS应用在前台时，收到推送，如果想以通知的形式告知用户，发起一个本地通知，如果用户点击了，可以在Update中处理
            var timeTrigger = new iOSNotificationTimeIntervalTrigger()
            {
                TimeInterval = new TimeSpan(0, 0, 1),
                Repeats = false
            };

            iOSNotification localNotification = new iOSNotification()
            {
                Title = "Remote: " + remoteNotification.Title,
                Body = "Remote: " + remoteNotification.Body,
                Subtitle = "Remote: " + remoteNotification.Subtitle,
                ShowInForeground = true,
                ForegroundPresentationOption = PresentationOption.Sound | PresentationOption.Alert,
                CategoryIdentifier = remoteNotification.CategoryIdentifier,
                ThreadIdentifier = remoteNotification.ThreadIdentifier,
                Trigger = timeTrigger,
                Data = remoteNotification.Data,
            };
            iOSNotificationCenter.ScheduleNotification(localNotification);
```

### API

接口类为 Assets/Plugins/PushHelper.cs

调用示例

```
using Aliyun.Push;

public class ClickHandler : MonoBehaviour
{
    void Start()
    {

#if UNITY_IOS
        PushHelper.Init("******", "********", (result, data) => Log("Init " + result + " " + data));
#elif UNITY_ANDROID
        PushHelper.Init(null, null, (result, data) => Log("Init " + result + " " + data));
#endif
        PushHelper.SetNotificationReceivedCallback((title, content, data) => Log("receive notification " + title + "\n content " + content + "\n data " + data));
        PushHelper.SetMessageReceivedCallback((title, content) => Log("receive message " + title + "\n content " + content));
    }

    public void Register()
    {
        Log("register push");
        PushHelper.Register(this, (result, data) => Log("Register " + result + " " + data));
    }

    public void BindAccount()
    {
        Log("BindAccount");
        PushHelper.BindAccount("account", (result, data) => Log("BindAccount " + result + " " + data));
    }

    public void UnBindAccount()
    {
        Log("UnBindAccount");
        PushHelper.UnBindAccount((result, data) => Log("UnBindAccount " + result + " " + data));
    }

    public void BindTag()
    {
        Log("BindTag");
        PushHelper.BindTag(1, "hello", null, (result, data) => Log("BindAccount " + result + " " + data));
    }

    public void UnBindTag()
    {
        Log("UnBindTag");
        PushHelper.UnBindTag(1, "hello", null, (result, data) => Log("UnBindTag " + result + " " + data));
    }

    public void TagList()
    {
        Log("ListTag");
        PushHelper.ListTag(1, (result, data) => Log("ListTag " + result + " " + data));
    }

    public void BindAlias()
    {
        Log("AddAlias");
        PushHelper.AddAlias("aliasTemp", (result, data) => Log("AddAlias " + result + " " + data));
    }

    public void UnBindAlias()
    {
        Log("RemoveAlias");
        PushHelper.RemoveAlias("aliasTemp", (result, data) => Log("RemoveAlias " + result + " " + data));
    }

    public void AliasList()
    {
        Log("ListAlias");
        PushHelper.ListAlias((result, data) => Log("ListAlias " + result + " " + data));
    }

    public void BindPhone()
    {
        Log("BindPhone");
        PushHelper.BindPhone("12345678901", (result, data) => Log("BindPhone " + result + " " + data));
    }

    public void UnBindPhone()
    {
        Log("UnBindPhone");
        PushHelper.UnBindPhone((result, data) => Log("UnBindPhone " + result + " " + data));
    }

    public void GetDeviceId()
    {
        Log("device id is " + PushHelper.DeviceId());
    }
}
```

#### 一般接口的回调说明

除了接收通知和消息的回调接口，其他回调一般格式为Action<bool, string>。

第一个参数bool表示此次请求是否成功。

第二个参数string 当成功时，表示获取到的数据，当失败时，表示错误信息。

主要方法如下：

#### Init 初始化推送

必须先初始化，才能正常使用。 **注意 Android的AppKey appSecret 通过manifest配置，此处只对iOS生效**

```
public static void Init(string appKey, string appSecret, Action<bool, string> callback)
```

#### Register 注册推送

在初始化之后，必须先注册推送通道，才能正常使用

````
public static void Register(MonoBehaviour mono, Action<bool, string> callback)
````

#### BindAccount 绑定业务账号

给设备绑定业务账号，绑定之后可以使用账号进行推送，参考https://help.aliyun.com/document_detail/195008.html?#title-zzo-xuu-r3o

```
public static void BindAccount(string account, Action<bool, string> callback)
```

#### UnBindAccount 解绑业务账号

解绑业务账号，解绑之后不可以使用账号进行推送，参考https://help.aliyun.com/document_detail/195008.html?#title-yd6-fa8-u5g

```
public static void UnBindAccount(Action<bool, string> callback)
```

#### BindTag 添加标签

给特定对象添加标签，以便使用标签进行推送，参数参考https://help.aliyun.com/document_detail/195010.html?#title-l97-wc7-904

```
public static void BindTag(int target, string tag, string alias, Action<bool, string> callback)
```

#### UnBindTag 移除标签

给特定对象移除标签，参考https://help.aliyun.com/document_detail/195010.html?#title-9r1-7qq-5s5

```
public static void UnBindTag(int target, string tag, string alias, Action<bool, string> callback)
```

#### ListTag 查询标签

查询标签，参考https://help.aliyun.com/document_detail/195010.html?#title-6q7-wn0-66t

```
public static void ListTag(int target, Action<bool, string> callback)
```

#### AddAlias 添加别名

给设备添加别名，以便使用别名进行推送，参考https://help.aliyun.com/document_detail/195011.html?#title-kjd-ybj-odm

```
public static void AddAlias(string alias, Action<bool, string> callback)
```

#### RemoveAlias 移除别名

移除设备别名，参考https://help.aliyun.com/document_detail/195011.html?#title-p9d-rqh-8oc

```
public static void RemoveAlias(string alias, Action<bool, string> callback)
```

#### ListAlias 查询别名

查询设备别名，参考https://help.aliyun.com/document_detail/195011.html?#title-buq-5yf-r0i

```
public static void ListAlias(Action<bool, string> callback)
```

#### BindPhone 绑定手机号

给设备绑定手机号，用于推送短信融合方案，参考https://help.aliyun.com/document_detail/195014.html?#title-t02-yj2-n12。**注意 iOS暂不支持**

```
public static void BindPhone(string phoneName, Action<bool, string> callback)
```

#### UnBindPhone 解绑手机号

解绑设备手机号，参考https://help.aliyun.com/document_detail/195014.html?#title-k21-32f-fay

```
public static void UnBindPhone(Action<bool, string> callback)
```

#### SetNotificationReceivedCallback 设置推送接收回调

当通知到到达时，回调设置的接口。Action参数分别是 通知标题 通知内容 通知额外数据，

其中通知额外数据，对应[推送接口](https://help.aliyun.com/knowledge_detail/48089.html?#h2-url-3)中iOSExtParameters 和 AndroidExtParameters中以**data**为key的数据

```
// Android
public static void SetNotificationReceivedCallback(Action<string, string, string> notificationReceivedCallback)

// iOS
public static void SetNotificationReceivedCallback(Action<string, string, string, iOSNotification> notificationReceivedCallback)
```

#### SetMessageReceivedCallback 设置消息接收回调

当消息到达时，回调设置的接口。Action的参数分别是 消息标题 消息内容。

```
public static void SetMessageReceivedCallback(Action<string, string> messageReceivedCallback)
```

#### DeviceId 获取推送设备标识

获取设备标识，可以基于设备进行推送

```
public static string DeviceId()
```

#### 检查用户是否打开应用通知，仅限Android

检查用户是否在设置的通知管理中允许应用通知

```
        public static bool IsNotificationEnabled()
```

#### 检查用户是否打开应用某个通知通道，仅限Android

检查用户是否在设置的通知管理中允许展示应用某个通知通道的通知

```
        public static bool IsNotificationChannelEnabled(string channelId)
```

#### 跳转应用的通知管理界面，仅限Android

跳转到应用的通知管理界面

```
        public static void JumpToNotificationSetting()
```

#### 跳转应用的通知通道管理界面，仅限Android

跳转应用的通知通道管理界面，部分品牌设备不支持，会跳转到通知管理界面

```
        public static void JumpToNotificationChannelSetting(string channelId)
```

### 发布记录

2021-04-19：
1. 增加Android用于检查通知管理状态和跳转通知管理界面的api
2. iOS增加-ObjC设置，适配国际版
3. demo日志文字展示不直接在回调设置
4. 增加iOS各种通知展示处理
5. demo改为使用国际版2019.4.12f1(225e826a680e)

2021-04-02:
1. 第一版发布