//
//  PushWrapper.h
//  Unity-iPhone
//
//  Created by 心定 on 2021/3/25.
//

#ifndef PushWrapper_h
#define PushWrapper_h

#import "PushHelper.h"


@interface PushWrapper : NSObject

@property MessageReceivedCallback onMessageReceivedCallback;
@property CloudPushCallback onPushActionCallback;

+ (instancetype)sharedInstance;

- (void)initCloudPush:(NSString *)appKey appSecret:(NSString *)appSecret actionId:(int)actionId;
- (void)reportToken:(NSString *)deviceToken actionId:(int)actionId;
- (void)bindAccount:(NSString *)account actionId:(int)actionId;
- (void)unBindAccount:(int)actionId;
- (void)bindTag:(int)target
       withTag:(NSString *)tag
      withAlias:(NSString *)alias
       actionId:(int)actionId;
- (void)unBindTag:(int)target
         withTag:(NSString *)tag
        withAlias:(NSString *)alias
         actionId:(int)actionId;
- (void)listTags:(int)target
        actionId:(int)actionId;
- (void)addAlias:(NSString *)alias
        actionId:(int)actionId;
- (void)removeAlias:(NSString *)alias
           actionId:(int)actionId;
- (void)listAliases:(int)actionId;
- (NSString *)deviceId;


@end

#endif /* PushWrapper_h */
