#import "PushHelper.h"
#import "PushWrapper.h"

@implementation PushHelper


@end

#if defined(__cplusplus)
extern "C" {
#endif
    
    extern NSString* toNSString (const char* string);
    extern id jsonDataToObject(NSData *data);
    extern NSArray *toNSArray(const char * datas);
    extern NSDictionary *mergedAccountDictionary(NSArray <NSDictionary *>* items);
    extern NSDictionary *mergedAttributesDictionary(NSArray <NSDictionary *>* items);
#if defined(__cplusplus)
}
#endif


#if defined(__cplusplus)
extern "C" {
#endif

   
    /// 将NSString转换为C#可以使用的 char *
    /// @param source 目标串
    static char *toCString(const char *source) {
        if (!source)return NULL;
        char *dest = static_cast<char*>(malloc(strlen(source) + 1));
        if (dest)strcpy(dest, source);
        return dest;
    }
    
    NSString *toNSString (const char *string) {
        return [NSString stringWithUTF8String:(string ? string : "")];
    }
    
    id jsonDataToObject(NSData *data) {
        if (!data) return nil;
        NSError *error = nil;
        id object = [NSJSONSerialization JSONObjectWithData:data options:0 error:&error];
        if (error) return nil;
        return object;
    }
    
    NSArray *toNSArray(const char * datas) {
        NSString *jsonString = toNSString(datas);
        if (!jsonString.length) {
            return nil;
        }
        NSData *data = [jsonString dataUsingEncoding:NSUTF8StringEncoding];
        NSDictionary *dict = jsonDataToObject(data);
        NSArray *array = [dict objectForKey:@"Items"];
        return array;
    }
    
    NSDictionary *mergedAccountDictionary(NSArray <NSDictionary *>* items) {
        NSMutableDictionary *dictionary = [NSMutableDictionary dictionary];
        for (NSDictionary *item in items) {
            NSNumber *key = item[@"type"];
            NSString *value = item[@"value"];
            dictionary[key] = value;
        }
        return dictionary;
    }
    
    NSDictionary *mergedAttributesDictionary(NSArray <NSDictionary *>* items) {
        NSMutableDictionary *dictionary = [NSMutableDictionary dictionary];
        for (NSDictionary *item in items) {
            NSString *key = item[@"key"];
            NSString *value = item[@"value"];
            dictionary[key] = value;
        }
        return dictionary;
    }

    const char * _setDebugMode(bool enable) {
        return nil;
    }

const char * _deviceId() {
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    return toCString([[wrapper deviceId] UTF8String]);
}

void _setCloudPushCallback(CloudPushCallback callback) {
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    wrapper.onPushActionCallback = callback;
}

void _setMessageCallback(MessageReceivedCallback callback) {
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    wrapper.onMessageReceivedCallback = callback;
}

void _initCloudPush(const char * appKey, const char * appSecret, int actionId) {
    NSString *appKeyTmp = toNSString(appKey);
    NSString *appSecretTmp = toNSString(appSecret);
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    [wrapper initCloudPush:appKeyTmp appSecret:appSecretTmp actionId:actionId];
}

void _reportToken(const char* deviceToken, int actionId){
    NSString *token = toNSString(deviceToken);
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    [wrapper reportToken:token actionId:actionId];
}

void _bindAccount(const char* account, int actionId){
    NSString *accountTmp = toNSString(account);
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    [wrapper bindAccount:accountTmp actionId:actionId];
}

void _unBindAccount(int actionId){
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    [wrapper unBindAccount:actionId];
}

void _bindTag(int target, const char* tag, const char* alias, int actionId) {
    NSString *tagTmp = toNSString(tag);
    NSString *aliasTmp = toNSString(alias);
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    [wrapper bindTag:target withTag:tagTmp withAlias:aliasTmp actionId:actionId];
}

void _unBindTag(int target, const char* tag, const char* alias, int actionId) {
    NSString *tagTmp = toNSString(tag);
    NSString *aliasTmp = toNSString(alias);
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    [wrapper unBindTag:target withTag:tagTmp withAlias:aliasTmp actionId:actionId];
}

void _listTag(int target, int actionId) {
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    [wrapper listTags:target actionId:actionId];
}

void _addAlias(const char* alias, int actionId) {
    NSString *aliasTmp = toNSString(alias);
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    [wrapper addAlias:aliasTmp actionId:actionId];
}

void _removeAlias(const char* alias, int actionId) {
    NSString *aliasTmp = toNSString(alias);
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    [wrapper removeAlias:aliasTmp actionId:actionId];
}

void _listAlias(int actionId) {
    PushWrapper* wrapper = [PushWrapper sharedInstance];
    [wrapper listAliases:actionId];
}

#if defined(__cplusplus)
}
#endif
