﻿using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System;
using UnityEngine;
using AOT;
#if UNITY_IOS
using Aliyun.Push.IOS;
using Unity.Notifications.iOS;
#elif UNITY_ANDROID
using Aliyun.Push.Android;
#endif

namespace Aliyun.Push
{
    public class PushHelper
    {

        public static void Init(string appKey, string appSecret, Action<bool, string> callback)
        {
#if UNITY_IOS
            iOSPushHelper.Init(appKey, appSecret, callback);
#elif UNITY_ANDROID
            AndroidPushHelper.Init();
            callback(true, null);
#endif
        }


        public static void Register(MonoBehaviour mono, Action<bool, string> callback)
        {
#if UNITY_IOS
            iOSPushHelper.RegisterDeviceToken(mono, callback);
#elif UNITY_ANDROID
            AndroidPushHelper.Register(callback);
#endif
        }

        public static void BindAccount(string account, Action<bool, string> callback)
        {
#if UNITY_IOS
            iOSPushHelper.BindAccount(account, callback);
#elif UNITY_ANDROID
            AndroidPushHelper.BindAccount(account, callback);
#endif
        }

        public static void UnBindAccount(Action<bool, string> callback)
        {
#if UNITY_IOS
            iOSPushHelper.UnBindAccount(callback);
#elif UNITY_ANDROID
            AndroidPushHelper.UnBindAccount(callback);
#endif
        }

        public static void BindTag(int target, string tag, string alias, Action<bool, string> callback)
        {
#if UNITY_IOS
            iOSPushHelper.BindTag(target, tag, alias, callback);
#elif UNITY_ANDROID
            AndroidPushHelper.BindTag(target, tag, alias, callback);
#endif
        }

        public static void UnBindTag(int target, string tag, string alias, Action<bool, string> callback)
        {
#if UNITY_IOS
            iOSPushHelper.UnBindTag(target, tag, alias, callback);
#elif UNITY_ANDROID
            AndroidPushHelper.UnBindTag(target, tag, alias, callback);
#endif
        }

        public static void ListTag(int target, Action<bool, string> callback)
        {
#if UNITY_IOS
            iOSPushHelper.ListTag(target, callback);
#elif UNITY_ANDROID
            AndroidPushHelper.ListTag(target, callback);
#endif
        }

        public static void AddAlias(string alias, Action<bool, string> callback)
        {
#if UNITY_IOS
            iOSPushHelper.AddAlias(alias, callback);
#elif UNITY_ANDROID
            AndroidPushHelper.AddAlias(alias, callback);
#endif
        }

        public static void RemoveAlias(string alias, Action<bool, string> callback)
        {
#if UNITY_IOS
            iOSPushHelper.RemoveAlias(alias, callback);
#elif UNITY_ANDROID
            AndroidPushHelper.RemoveAlias(alias, callback);
#endif
        }

        public static void ListAlias(Action<bool, string> callback)
        {
#if UNITY_IOS
            iOSPushHelper.ListAlias(callback);
#elif UNITY_ANDROID
            AndroidPushHelper.ListAlias(callback);
#endif
        }

        public static void BindPhone(string phoneName, Action<bool, string> callback)
        {
#if UNITY_IOS
            callback(false, "not support");
#elif UNITY_ANDROID
            AndroidPushHelper.BindPhone(phoneName, callback);
#endif
        }

        public static void UnBindPhone(Action<bool, string> callback)
        {
#if UNITY_IOS
            callback(false, "not support");
#elif UNITY_ANDROID
            AndroidPushHelper.UnBindPhone(callback);
#endif
        }

        public static string DeviceId()
        {
#if UNITY_IOS
            return iOSPushHelper.DeviceId();
#elif UNITY_ANDROID
            return AndroidPushHelper.DeviceId();
#else
            return "";
#endif
        }

#if UNITY_ANDROID
        public static void SetNotificationReceivedCallback(Action<string, string, string> notificationReceivedCallback)
        {
            AndroidPushHelper.SetNotificationReceivedCallback((title, content, data) => {
                notificationReceivedCallback(title, content, data);
            });
        }
#endif

#if UNITY_IOS
        public static void SetNotificationReceivedCallback(Action<string, string, string, iOSNotification> notificationReceivedCallback)
        {
            iOSPushHelper.SetNotificationReceivedCallback((notification) => {
                notificationReceivedCallback(notification.Title, notification.Body, notification.Data, notification);
            });
        }
#endif

        public static void SetMessageReceivedCallback(Action<string, string> messageReceivedCallback)
        {
#if UNITY_IOS
            iOSPushHelper.SetMessageReceivedCallback(messageReceivedCallback);
#elif UNITY_ANDROID
            AndroidPushHelper.SetMessageReceivedCallback(messageReceivedCallback);
#endif
        }

        public static bool IsNotificationEnabled()
        {
#if UNITY_ANDROID
            return AndroidPushHelper.IsNotificationEnabled();
#else
            return true;
#endif
        }

        public static bool IsNotificationChannelEnabled(string channelId)
        {
#if UNITY_ANDROID
            return AndroidPushHelper.IsNotificationChannelEnabled(channelId);
#else
            return true;
#endif
        }

        public static void JumpToNotificationSetting()
        {
#if UNITY_IOS
            return;
#elif UNITY_ANDROID
            AndroidPushHelper.JumpToNotificationSetting();
#endif
        }

        public static void JumpToNotificationChannelSetting(string channelId)
        {
#if UNITY_IOS
            return;
#elif UNITY_ANDROID
            AndroidPushHelper.JumpToNotificationChannelSetting(channelId);
#endif
        }

    }
}


