#if UNITY_IOS
using System;
using System.IO;
using System.Collections.Generic;
using UnityEditor;
using UnityEditor.Callbacks;
using UnityEditor.iOS.Xcode;
using UnityEngine;
using Unity.Notifications;
using Unity.Notifications.iOS;

public class iOSAliyunPushPostProcessor : MonoBehaviour
{
    [PostProcessBuild]
    public static void OnPostprocessBuild(BuildTarget buildTarget, string path)
    {
        if (buildTarget != BuildTarget.iOS)
            return;

       
        PatchPBXProject(path);
    }

    private static void PatchPBXProject(string path)
    {
        var pbxProjectPath = PBXProject.GetPBXProjectPath(path);

        var pbxProject = new PBXProject();
        pbxProject.ReadFromString(File.ReadAllText(pbxProjectPath));

        string mainTarget;
        string unityFrameworkTarget;

        var unityMainTargetGuidMethod = pbxProject.GetType().GetMethod("GetUnityMainTargetGuid");
        var unityFrameworkTargetGuidMethod = pbxProject.GetType().GetMethod("GetUnityFrameworkTargetGuid");

        if (unityMainTargetGuidMethod != null && unityFrameworkTargetGuidMethod != null)
        {
            mainTarget = (string)unityMainTargetGuidMethod.Invoke(pbxProject, null);
            unityFrameworkTarget = (string)unityFrameworkTargetGuidMethod.Invoke(pbxProject, null);
        }
        else
        {
            mainTarget = pbxProject.TargetGuidByName("Unity-iPhone");
            unityFrameworkTarget = mainTarget;
        }

        // Add necessary frameworks.
        pbxProject.AddFrameworkToProject(unityFrameworkTarget, "libz.tbd", false);
        pbxProject.AddFrameworkToProject(unityFrameworkTarget, "libresolv.tbd", false);
        pbxProject.AddFrameworkToProject(unityFrameworkTarget, "CoreTelephony.framework", false);
        pbxProject.AddFrameworkToProject(unityFrameworkTarget, "SystemConfiguration.framework", false);
        pbxProject.AddFrameworkToProject(unityFrameworkTarget, "libsqlite3.tbd", false);
        // Add -ObjC
        pbxProject.AddBuildProperty(unityFrameworkTarget, "OTHER_LDFLAGS", "-ObjC");


        File.WriteAllText(pbxProjectPath, pbxProject.WriteToString());
    }
}
#endif
