#if UNITY_ANDROID
using System.Collections;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System;
using UnityEngine;
using AOT;
using System.Threading;

namespace Aliyun.Push.Android
{
    public class AndroidPushHelper
    {
        private static Dictionary<int, Action<bool, string>> CallbackPairs = new Dictionary<int, Action<bool, string>>();
        private static int ActionIndex = 0;
        private static AndroidJavaClass pushWrapper;
        private static Action<string, string, string> customNotificationReceivedCallback;
        private static Action<string, string> customMessageReceivedCallback;

        class PushCallback : AndroidJavaProxy
        {
            public PushCallback() : base("com.alibaba.sdk.android.pushwrapper.PushCallback") { }
            void callback(int actionId, bool success, string data)
            {
                Debug.Log(success + " " + data);
                // call cs code
                Action<bool, string> callback = CallbackPairs[actionId];
                if (callback != null)
                {
                    callback(success, data);
                    CallbackPairs.Remove(actionId);
                }
            }
        }

        class NotificationReceivedCallback : AndroidJavaProxy
        {
            public NotificationReceivedCallback() : base("com.alibaba.sdk.android.pushwrapper.NotificationReceivedCallback") { }
            void receive(string title, string content, string extras, string data)
            {
                Debug.Log("receive notification " + title
                    + "\n content " + content
                    + "\n extras " + extras
                    + "\n data " + data);
                // call cs code
                if (customNotificationReceivedCallback != null)
                {
                    customNotificationReceivedCallback(title, content, data);
                }
            }
        }

        class MessageReceivedCallback : AndroidJavaProxy
        {
            public MessageReceivedCallback() : base("com.alibaba.sdk.android.pushwrapper.MessageReceivedCallback") { }
            void receive(string title, string content)
            {
                Debug.Log("receive message " + title
                    + "\n content " + content);
                // call cs code
                if (customMessageReceivedCallback != null)
                {
                    customMessageReceivedCallback(title, content);
                }
            }
        }

        public static void SetNotificationReceivedCallback(Action<string, string, string> notificationReceivedCallback)
        {
            customNotificationReceivedCallback = notificationReceivedCallback;
        }

        public static void SetMessageReceivedCallback(Action<string, string> messageReceivedCallback)
        {
            customMessageReceivedCallback = messageReceivedCallback;
        }

        public static void Init()
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                pushWrapper.CallStatic("setPushCallback", new PushCallback());
                pushWrapper.CallStatic("setNotificationReceivedCallback", new NotificationReceivedCallback());

            }           
        }

        public static void Register(Action<bool, string> callback)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("register", actionId);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }
        }

        public static void BindAccount(string account, Action<bool, string> callback)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("bindAccount", actionId, account);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }
        }

        public static void UnBindAccount(Action<bool, string> callback)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("unbindAccount", actionId);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }            
        }

        public static void BindTag(int target, string tag, string alias, Action<bool, string> callback)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("bindTag", actionId, target, tag, alias);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }           
        }

        public static void UnBindTag(int target, string tag, string alias, Action<bool, string> callback)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("unbindTag", actionId, target, tag, alias);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }            
        }

        public static void ListTag(int target, Action<bool, string> callback)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("listTag", actionId, target);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }

        }

        public static void AddAlias(string alias, Action<bool, string> callback)
        {

            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("addAlias", actionId, alias);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }
        }

        public static void RemoveAlias(string alias, Action<bool, string> callback)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("removeAlias", actionId, alias);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }
        }

        public static void ListAlias(Action<bool, string> callback)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("listAlias", actionId);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }
        }

        public static void BindPhone(string phoneName, Action<bool, string> callback)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("bindPhone", actionId, phoneName);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }
        }

        public static void UnBindPhone(Action<bool, string> callback)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                int actionId = Interlocked.Increment(ref ActionIndex);
                CallbackPairs.Add(actionId, callback);
                pushWrapper.CallStatic("unbindPhone", actionId);
            }
            else
            {
                callback(false, "pushWrapper is null");
            }
        }

        public static string DeviceId()
        {

            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                return pushWrapper.CallStatic<string>("deviceId");
            }
            else
            {
                Debug.Log("pushWrapper is null");
                return null;
            }
        }

        public static bool IsNotificationEnabled()
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                return pushWrapper.CallStatic<bool>("isNotificationEnabled");
            }
            else
            {
                Debug.Log("pushWrapper is null");
                return true;
            }
        }

        public static bool IsNotificationChannelEnabled(string channelId)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                return pushWrapper.CallStatic<bool>("isNotificationChannelEnabled", channelId);
            }
            else
            {
                Debug.Log("pushWrapper is null");
                return true;
            }
        }

        public static void JumpToNotificationSetting()
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                pushWrapper.CallStatic("jumpToNotificationSetting");
            }
            else
            {
                Debug.Log("pushWrapper is null");
            }
        }

        public static void JumpToNotificationChannelSetting(string channelId)
        {
            AndroidJavaClass pushWrapper = getAndroidPushWrapper();
            if (pushWrapper != null)
            {
                pushWrapper.CallStatic("jumpToNotificationChannelSetting", channelId);
            }
            else
            {
                Debug.Log("pushWrapper is null");
            }
        }


        private static AndroidJavaClass getAndroidPushWrapper()
        {
            if (pushWrapper == null)
            {
                pushWrapper = new AndroidJavaClass("com.alibaba.sdk.android.pushwrapper.PushHelper");
                if (pushWrapper != null)
                {
                    return pushWrapper;
                }
                else
                {
                    Debug.Log("pushWrapper is null");
                    return null;
                }
            }
            return pushWrapper;
        }
    }
}
#endif