﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using Aliyun.Push;
#if UNITY_IOS
using Unity.Notifications.iOS;
#endif
#if UNITY_ANDROID
using Unity.Notifications.Android;
#endif


public class ClickHandler : MonoBehaviour
{
    public Text txt;
    private string allLog;
    private string lastHandledNotificationId;
    // Start is called before the first frame update
    void Start()
    {
        Screen.SetResolution(857, 415, true);
#if UNITY_IOS
        // 需要替换阿里云平台的appKey和appSecret
        PushHelper.Init("********", "********", (result, data) => Log("Init " + result + " " + data));
#elif UNITY_ANDROID
        var channel = new AndroidNotificationChannel()
        {
            Id = "8.0up",
            Name = "Default Channel",
            Importance = Importance.Default,
            Description = "Generic notifications",
        };
        AndroidNotificationCenter.RegisterNotificationChannel(channel);
        PushHelper.Init(null, null, (result, data) => Log("Init " + result + " " + data));
#endif
#if UNITY_IOS
        PushHelper.SetNotificationReceivedCallback((title, content, data, remoteNotification) => {
            Log("receive notification " + title + "\n content " + content + "\n data " + data);
            // 当iOS应用在前台时，收到推送，如果想以通知的形式告知用户，发起一个本地通知，如果用户点击了，可以在Update中处理
            var timeTrigger = new iOSNotificationTimeIntervalTrigger()
            {
                TimeInterval = new TimeSpan(0, 0, 1),
                Repeats = false
            };

            iOSNotification localNotification = new iOSNotification()
            {
                Title = "Remote: " + remoteNotification.Title,
                Body = "Remote: " + remoteNotification.Body,
                Subtitle = "Remote: " + remoteNotification.Subtitle,
                ShowInForeground = true,
                ForegroundPresentationOption = PresentationOption.Sound | PresentationOption.Alert,
                CategoryIdentifier = remoteNotification.CategoryIdentifier,
                ThreadIdentifier = remoteNotification.ThreadIdentifier,
                Trigger = timeTrigger,
                Data = remoteNotification.Data,
            };
            iOSNotificationCenter.ScheduleNotification(localNotification);

        });
#elif UNITY_ANDROID
        PushHelper.SetNotificationReceivedCallback((title, content, data) => {
            Log("receive notification " + title + "\n content " + content + "\n data " + data);
        });
#endif
        PushHelper.SetMessageReceivedCallback((title, content) => Log("receive message " + title + "\n content " + content));
    }

    // Update is called once per frame
    void Update()
    {
        txt.text = allLog;
#if UNITY_IOS
            // 应用未启动，推送，用户点击，拉起应用，获取通知内容
            // 应用在后台，推送，用户点击，应用回到前台，获取通知内容
            // 应用在前台，推送，回调中创建本地通知，用户点击，获取通知内容
            var notification = iOSNotificationCenter.GetLastRespondedNotification();
            if (notification != null && notification.Identifier != lastHandledNotificationId)
            {
                lastHandledNotificationId = notification.Identifier;
                var msg = "Last Received Notification: " + notification.Identifier;
                msg += "\n - Notification received: ";
                msg += "\n - .Title: " + notification.Title;
                msg += "\n - .Badge: " + notification.Badge;
                msg += "\n - .Body: " + notification.Body;
                msg += "\n - .CategoryIdentifier: " + notification.CategoryIdentifier;
                msg += "\n - .Subtitle: " + notification.Subtitle;
                msg += "\n - .Data: " + notification.Data;
                Log(msg);
            }
            // 清除小红点
            iOSNotificationCenter.ApplicationBadge = 0;
#endif
    }

    public void CheckNotification()
    {
        bool enabled = PushHelper.IsNotificationEnabled();
        Log("CheckNotification "+enabled);
    }

    public void CheckNotificationChannel()
    {
        bool enabled = PushHelper.IsNotificationChannelEnabled("8.0up");
        Log("CheckNotificationChannel "+enabled);
    }
    public void JumpToNotificationSetting()
    {
        PushHelper.JumpToNotificationSetting();
        Log("JumpToNotificationSetting ");
    }
    public void JumpToNotificationChannelSetting()
    {
        PushHelper.JumpToNotificationChannelSetting("8.0up");
        Log("JumpToNotificationChannelSetting");
    }

    public void Register()
    {
        Log("register push");
        PushHelper.Register(this, (result, data) => Log("Register " + result + " " + data));
    }

    public void BindAccount()
    {
        Log("BindAccount");
        PushHelper.BindAccount("account", (result, data) => Log("BindAccount account " + result + " " + data));
    }

    public void UnBindAccount()
    {
        Log("UnBindAccount");
        PushHelper.UnBindAccount((result, data) => Log("UnBindAccount " + result + " " + data));
    }

    public void BindTag()
    {
        Log("BindTag");
        PushHelper.BindTag(1, "hello", null, (result, data) => Log("BindTag device hello " + result + " " + data));
    }

    public void UnBindTag()
    {
        Log("UnBindTag");
        PushHelper.UnBindTag(1, "hello", null, (result, data) => Log("UnBindTag " + result + " " + data));
    }

    public void TagList()
    {
        Log("ListTag");
        PushHelper.ListTag(1, (result, data) => Log("ListTag " + result + " " + data));
    }

    public void BindAlias()
    {
        Log("AddAlias");
        PushHelper.AddAlias("aliasTemp", (result, data) => Log("AddAlias aliasTemp " + result + " " + data));
    }

    public void UnBindAlias()
    {
        Log("RemoveAlias");
        PushHelper.RemoveAlias("aliasTemp", (result, data) => Log("RemoveAlias " + result + " " + data));
    }

    public void AliasList()
    {
        Log("ListAlias");
        PushHelper.ListAlias((result, data) => Log("ListAlias " + result + " " + data));
    }

    public void BindPhone()
    {
        Log("BindPhone");
        PushHelper.BindPhone("12345678901", (result, data) => Log("BindPhone " + result + " " + data));
    }

    public void UnBindPhone()
    {
        Log("UnBindPhone");
        PushHelper.UnBindPhone((result, data) => Log("UnBindPhone " + result + " " + data));
    }

    public void GetDeviceId()
    {
        Log("device id is " + PushHelper.DeviceId());
    }

    public void Clean()
    {
        allLog = "Clean log";
    }

    private void Log(string log)
    {
        Debug.Log(log);
        allLog = allLog + '\n' + log;
    }
}
